using System;
using System.Collections;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.GUI;
using gov.va.med.vbecs.GUI.controls;

namespace gov.va.med.vbecs.admin.GUI
{
	/// <summary>
	/// Summary description for dlgInactivateUsers.
	/// </summary>
	public class dlgInactivateUsers : System.Windows.Forms.Form
	{
		private IList _usersList;

		private System.Windows.Forms.Label lblMessage;
		private System.Windows.Forms.ListBox lstUsers;
		private System.Windows.Forms.Label lblQuestion;
		private System.Windows.Forms.Button btnYes;
		private System.Windows.Forms.Button btnNo;
		private System.Windows.Forms.GroupBox grpSplit;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public dlgInactivateUsers()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="usersInactivatedInVista"></param>
		public dlgInactivateUsers( IList usersInactivatedInVista ) : this()
		{
			if( usersInactivatedInVista == null )
				throw( new ArgumentNullException( "usersInactivatedInVista" ) );

			_usersList = usersInactivatedInVista;
		}

		/// <summary>
		/// Load Event
		/// </summary>
		/// <param name="e"></param>
		protected override void OnLoad(EventArgs e)
		{
			base.OnLoad (e);

			using( new WaitCursor() )
				PopulateListBoxWithUsers();
		}

		private void PopulateListBoxWithUsers()
		{
			lstUsers.Items.Clear();
			lstUsers.BeginUpdate();

			foreach( VbecsUser _user in _usersList )
				lstUsers.Items.Add( _user.UserName );
			
			lstUsers.EndUpdate();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.lblMessage = new System.Windows.Forms.Label();
			this.lstUsers = new System.Windows.Forms.ListBox();
			this.lblQuestion = new System.Windows.Forms.Label();
			this.btnYes = new System.Windows.Forms.Button();
			this.btnNo = new System.Windows.Forms.Button();
			this.grpSplit = new System.Windows.Forms.GroupBox();
			this.SuspendLayout();
			// 
			// lblMessage
			// 
			this.lblMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblMessage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblMessage.Location = new System.Drawing.Point(8, 4);
			this.lblMessage.Name = "lblMessage";
			this.lblMessage.Size = new System.Drawing.Size(268, 24);
			this.lblMessage.TabIndex = 0;
			this.lblMessage.Text = "The following user(s) have been marked as inactive in VistA, but are still active" +
				" in VBECS:";
			this.lblMessage.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lstUsers
			// 
			this.lstUsers.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lstUsers.BackColor = System.Drawing.SystemColors.Control;
			this.lstUsers.ItemHeight = 14;
			this.lstUsers.Location = new System.Drawing.Point(8, 32);
			this.lstUsers.Name = "lstUsers";
			this.lstUsers.Size = new System.Drawing.Size(268, 88);
			this.lstUsers.TabIndex = 1;
			// 
			// lblQuestion
			// 
			this.lblQuestion.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblQuestion.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblQuestion.Location = new System.Drawing.Point(8, 136);
			this.lblQuestion.Name = "lblQuestion";
			this.lblQuestion.Size = new System.Drawing.Size(268, 20);
			this.lblQuestion.TabIndex = 2;
			this.lblQuestion.Text = "Do you want to inactivate the user(s) in VBECS?";
			this.lblQuestion.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnYes
			// 
			this.btnYes.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.btnYes.DialogResult = System.Windows.Forms.DialogResult.Yes;
			this.btnYes.Location = new System.Drawing.Point(60, 160);
			this.btnYes.Name = "btnYes";
			this.btnYes.TabIndex = 3;
			this.btnYes.Text = "&Yes";
			// 
			// btnNo
			// 
			this.btnNo.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.btnNo.DialogResult = System.Windows.Forms.DialogResult.No;
			this.btnNo.Location = new System.Drawing.Point(140, 160);
			this.btnNo.Name = "btnNo";
			this.btnNo.TabIndex = 4;
			this.btnNo.Text = "&No";
			// 
			// grpSplit
			// 
			this.grpSplit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSplit.Location = new System.Drawing.Point(8, 124);
			this.grpSplit.Name = "grpSplit";
			this.grpSplit.Size = new System.Drawing.Size(268, 7);
			this.grpSplit.TabIndex = 5;
			this.grpSplit.TabStop = false;
			// 
			// dlgInactivateUsers
			// 
			this.AcceptButton = this.btnYes;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnNo;
			this.ClientSize = new System.Drawing.Size(282, 187);
			this.Controls.Add(this.grpSplit);
			this.Controls.Add(this.btnNo);
			this.Controls.Add(this.btnYes);
			this.Controls.Add(this.lblQuestion);
			this.Controls.Add(this.lstUsers);
			this.Controls.Add(this.lblMessage);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
			this.Name = "dlgInactivateUsers";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "Inactivate Users?";
			this.ResumeLayout(false);

		}
		#endregion
	}
}
